const mongoose = require('mongoose');

// Define the database model
const UserSchema = new mongoose.Schema({
  nombre: {
    type: String,
    required: [true, 'Nombre es requerido.'],
  },
  apellido: {
    type: String,
    required: [true, 'Apellido es requerido.'],
  },
  correo: {
    type: String,
    required: [true, 'Correo es requerido.'],
  },
  usuario: {
    type: String,
    required: [true, 'Usuario es requerido.'],
  },
  contrasena: {
    type: String,
    required: [true, 'Contraseña es requerida.'],
  },
  fecha: {
    type: Date,
    required: [true, 'Fecha es requerido.']
  },
  estado: {
    type: Boolean,
    default:true,
    required:[true, 'Estado es requerido.'],
  },
});

const Usuario = module.exports = mongoose.model('usuarios', UserSchema);
