"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var react_component_event_listener_1 = require("@fluentui/react-component-event-listener");
var enzyme_1 = require("enzyme");
var React = require("react");
var ReactTestUtils = require("react-dom/test-utils");
// @ts-ignore
var simulant = require("simulant");
var TestBoundary = /** @class */ (function (_super) {
    __extends(TestBoundary, _super);
    function TestBoundary() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = { hasError: false };
        return _this;
    }
    TestBoundary.prototype.componentDidCatch = function (error) {
        this.props.onError(error);
        this.setState({ hasError: true });
    };
    TestBoundary.prototype.render = function () {
        if (this.state.hasError) {
            return null;
        }
        return this.props.children;
    };
    return TestBoundary;
}(React.Component));
describe('EventListener', function () {
    describe('listener', function () {
        it('handles events on `target`', function () {
            var onClick = jest.fn();
            var onKeyDown = jest.fn();
            enzyme_1.mount(React.createElement(React.Fragment, null,
                React.createElement(react_component_event_listener_1.EventListener, { listener: onClick, targetRef: react_component_event_listener_1.documentRef, type: "click" }),
                React.createElement(react_component_event_listener_1.EventListener, { listener: onKeyDown, targetRef: react_component_event_listener_1.documentRef, type: "keydown" })));
            simulant.fire(document, 'click');
            simulant.fire(document, 'keydown');
            expect(onClick).toHaveBeenCalledTimes(1);
            expect(onClick).toHaveBeenCalledWith(expect.objectContaining({ type: 'click' }));
            expect(onKeyDown).toHaveBeenCalledTimes(1);
            expect(onKeyDown).toHaveBeenCalledWith(expect.objectContaining({ type: 'keydown' }));
        });
        it('unsubscribes correctly', function () {
            var onClick = jest.fn();
            var wrapper = enzyme_1.mount(React.createElement(react_component_event_listener_1.EventListener, { listener: onClick, targetRef: react_component_event_listener_1.documentRef, type: "click" }));
            ReactTestUtils.act(function () {
                wrapper.unmount();
            });
            simulant.fire(document, 'click');
            expect(onClick).not.toHaveBeenCalled();
        });
    });
    describe('capture', function () {
        it('passes "false" by default', function () {
            var addEventListener = jest.spyOn(document, 'addEventListener');
            var removeEventListener = jest.spyOn(document, 'removeEventListener');
            var wrapper = enzyme_1.mount(React.createElement(react_component_event_listener_1.EventListener, { listener: function () { }, targetRef: react_component_event_listener_1.documentRef, type: "click" }));
            ReactTestUtils.act(function () {
                wrapper.unmount();
            });
            expect(addEventListener).toHaveBeenCalledWith('click', expect.any(Function), false);
            expect(removeEventListener).toHaveBeenCalledWith('click', expect.any(Function), false);
        });
        it('passes `capture` prop when it is defined', function () {
            var addEventListener = jest.spyOn(document, 'addEventListener');
            var removeEventListener = jest.spyOn(document, 'removeEventListener');
            var wrapper = enzyme_1.mount(React.createElement(react_component_event_listener_1.EventListener, { capture: true, listener: function () { }, targetRef: react_component_event_listener_1.documentRef, type: "click" }));
            ReactTestUtils.act(function () {
                wrapper.unmount();
            });
            expect(addEventListener).toHaveBeenCalledWith('click', expect.any(Function), true);
            expect(removeEventListener).toHaveBeenCalledWith('click', expect.any(Function), true);
        });
    });
    describe('type', function () {
        it('handles changes', function () {
            var listener = jest.fn();
            var wrapper = enzyme_1.mount(React.createElement(react_component_event_listener_1.EventListener, { listener: listener, targetRef: react_component_event_listener_1.documentRef, type: "click" }));
            simulant.fire(document, 'click');
            expect(listener).toHaveBeenCalledTimes(1);
            wrapper.setProps({ type: 'scroll' });
            simulant.fire(document, 'scroll');
            expect(listener).toHaveBeenCalledTimes(2);
        });
    });
    describe('target', function () {
        it('handles events', function () {
            var listener = jest.fn();
            enzyme_1.mount(React.createElement(react_component_event_listener_1.EventListener, { listener: listener, target: document, type: "click" }));
            simulant.fire(document, 'click');
            expect(listener).toHaveBeenCalledTimes(1);
        });
        it('throws an error when is used with `targetRef`', function () {
            jest.spyOn(console, 'error').mockImplementation(function () { });
            var onError = jest.fn();
            enzyme_1.mount(React.createElement(TestBoundary, { onError: onError },
                React.createElement(react_component_event_listener_1.EventListener, { listener: jest.fn(), target: document, targetRef: react_component_event_listener_1.documentRef, type: "click" })));
            expect(onError).toBeCalledWith(expect.objectContaining({
                message: '`target` and `targetRef` props are mutually exclusive, please use one of them.',
            }));
            // We need to clean up mocks to avoid errors reported by React
            // eslint-disable-next-line no-console
            console.error.mockClear();
        });
        it('throws an error when not defined', function () {
            jest.spyOn(console, 'error').mockImplementation(function () { });
            var onError = jest.fn();
            enzyme_1.mount(React.createElement(TestBoundary, { onError: onError },
                React.createElement(react_component_event_listener_1.EventListener, { listener: jest.fn(), type: "click" })));
            expect(onError).toBeCalledWith(expect.objectContaining({
                message: "`target` and `targetRef` props are `undefined`, it' required to use one of them.",
            }));
            // We need to clean up mocks to avoid errors reported by React
            // eslint-disable-next-line no-console
            console.error.mockClear();
        });
    });
    describe('targetRef', function () {
        it('handles events', function () {
            var listener = jest.fn();
            enzyme_1.mount(React.createElement(react_component_event_listener_1.EventListener, { listener: listener, targetRef: react_component_event_listener_1.documentRef, type: "click" }));
            simulant.fire(document, 'click');
            expect(listener).toHaveBeenCalledTimes(1);
        });
    });
});
