"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.Ref = void 0;

var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));

var React = _interopRequireWildcard(require("react"));

var ReactIs = _interopRequireWildcard(require("react-is"));

var _RefFindNode = require("./RefFindNode");

var _RefForward = require("./RefForward");

var _excluded = ["children", "innerRef"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var Ref = function Ref(props) {
  var children = props.children,
      innerRef = props.innerRef,
      rest = (0, _objectWithoutPropertiesLoose2.default)(props, _excluded);
  var child = React.Children.only(children);
  var ElementType = ReactIs.isForwardRef(child) ? _RefForward.RefForward : _RefFindNode.RefFindNode;
  var childWithProps = child && rest && Object.keys(rest).length > 0 ? /*#__PURE__*/React.cloneElement(child, rest) : child;
  return /*#__PURE__*/React.createElement(ElementType, {
    innerRef: innerRef
  }, childWithProps);
};

exports.Ref = Ref;
//# sourceMappingURL=Ref.js.map
