"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ref = void 0;
var React = require("react");
var ReactIs = require("react-is");
var RefFindNode_1 = require("./RefFindNode");
var RefForward_1 = require("./RefForward");
var Ref = function (props) {
    var children = props.children, innerRef = props.innerRef, rest = __rest(props, ["children", "innerRef"]);
    var child = React.Children.only(children);
    var ElementType = ReactIs.isForwardRef(child) ? RefForward_1.RefForward : RefFindNode_1.RefFindNode;
    var childWithProps = child && rest && Object.keys(rest).length > 0 ? React.cloneElement(child, rest) : child;
    return React.createElement(ElementType, { innerRef: innerRef }, childWithProps);
};
exports.Ref = Ref;
