import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
var _excluded = ["children", "innerRef"];
import * as React from 'react';
import * as ReactIs from 'react-is';
import { RefFindNode } from './RefFindNode';
import { RefForward } from './RefForward';
export var Ref = function Ref(props) {
  var children = props.children,
      innerRef = props.innerRef,
      rest = _objectWithoutPropertiesLoose(props, _excluded);

  var child = React.Children.only(children);
  var ElementType = ReactIs.isForwardRef(child) ? RefForward : RefFindNode;
  var childWithProps = child && rest && Object.keys(rest).length > 0 ? /*#__PURE__*/React.cloneElement(child, rest) : child;
  return /*#__PURE__*/React.createElement(ElementType, {
    innerRef: innerRef
  }, childWithProps);
};
//# sourceMappingURL=Ref.js.map
