import { Component } from 'react';
import { Container } from 'semantic-ui-react';
import axios from 'axios';
import './App.css';
import Framework from '../CustomTable/Framework';

class App extends Component {
  constructor(

  ) {
    super();
    //  this.server = process.env.REACT_APP_API_URL || 'https://cementeriosayausi.herokuapp.com';
    //this.server = 'https://cementeriosayausi.herokuapp.com';
    this.server = 'http://localhost:3000';
    this.state = { clientes: []}
    this.fetchClientes = this.fetchClientes.bind(this);
    this.handleClienteAdded = this.handleClienteAdded.bind(this);
    this.handleClienteUpdated = this.handleClienteUpdated.bind(this);
    this.handleClienteDeleted = this.handleClienteDeleted.bind(this);
    this.handleLogout = this.handleLogout.bind(this);

  }

  // Fetch users when the component is mounted
  componentDidMount() {
    this.fetchClientes();

  }
  // Fetch users from the back-end API

  fetchClientes() {
    axios.get(`${this.server}/api/clientes/`)
      .then((response) => {
        this.setState({ clientes: response.data });
      })
      .catch((err) => {
        console.log(err);
      });
  }

// Handle user added event
  handleClienteAdded(cliente) {
    let clientes = this.state.clientes.slice();
    clientes.push(cliente);
    this.setState({ clientes: clientes });
  }

  handleClienteUpdated(cliente) {
    let clientes = this.state.clientes.slice();

    let i = clientes.findIndex(u => u._id === cliente._id)

    if (clientes.length > i) { clientes[i] = cliente }

    this.setState({ clientes: clientes });
  }

// Handle cliente deleted event

  handleClienteDeleted(cliente) {
    let clientes = this.state.clientes.slice();
    clientes = clientes.filter(u => { return u._id !== cliente._id; });
    this.setState({ clientes: clientes });
  }
  // Logout: intenta usar un callback pasado por props para volver a la pantalla de login sin recargar
  handleLogout(e) {
    if (e && e.preventDefault) e.preventDefault();
    if (this.props && typeof this.props.onLogout === 'function') {
      this.props.onLogout();
    } else {
      // fallback: recargar la página
      window.location.reload();
    }
  }
  render() {
    return (
      <div>  
        <div className='App'>
          <p className='App-intro'>Cementerio - GAD de la Parroquia Sayausi 
          </p>
          <div className='App-subintro' >Usuario: {this.props.name} - <button href=" " onClick={this.handleLogout}>Salir</button></div> 
          
        </div>
        <Container>
          <Framework
            data={this.state.clientes}
            onClienteAdded={this.handleClienteAdded}
            onClienteUpdated={this.handleClienteUpdated}
            onClienteDeleted={this.handleClienteDeleted}
            server={this.server}
          />
  </Container>
        <br />
      </div>


    );
  }
}

export default App;


