import React, { Component } from "react";
import ExcelExport from "../DownloadXLS/ExcelExport";
import { Input, Grid } from "semantic-ui-react";
import CustomTable from "./CustomTable"
import Styles from "./style.module.css";
import ModalUser from '../ModalUser/ModalUser';
import ModalTotal from "../ModalTotal/ModalTotal";

export default class Framework extends Component {
	state = {
		search: "",
	};
		
	handleInputs = (e) => {
		const { name, value } = e.target;
		this.setState({
			[name]: value,
		});
	};

	render() {

		const { search } = this.state;
		const tabla = JSON.parse(JSON.stringify(this.props.data));
		tabla.forEach(object =>{
			if(object.estado === false ){
				object.estado = 'No pagado';
			}else{
				object.estado = 'Pagado';
			}
		});
		tabla.forEach(object =>{
				object.fecha = object.fecha.split("T")[0];
		});
		return (
			<div className={Styles.container}>
			<Grid columns={"equal"}>
            <Grid.Column >
          	<ModalUser
            	headerTitle='Añadir Unidad de Sepultura'
            	buttonTriggerTitle=' Añadir Unidad de Sepultura'
            	buttonSubmitTitle='Guardar'
            	buttonColor='brown'
            	onClienteAdded={this.props.onClienteAdded}
				server={this.props.server}
				iconName='user'
			/>
			</Grid.Column> 
			<Grid.Column >
				<ExcelExport data={this.props.data} fileName="cementerio_sayausi" />
			</Grid.Column>
			<Grid.Column >
			<ModalTotal
				headerTitle='Totales Registrados'
				buttonTriggerTitle=' Totales Registrados'
            	buttonColor='orange'
				data={this.props.data}>	
			</ModalTotal>
            </Grid.Column>
            <Grid.Column >	
			<Input  
				size='massive'
				name={"search"}
				placeholder={"Buscar ..."}
				onChange={this.handleInputs}
				value={search}
			></Input>
            </Grid.Column>
            </Grid>

			<CustomTable
				data={this.props.data}
				headers={["Codigo",  "Nombre", "Apellido", "Responsable", "Fecha", "Valor","Estado", "Acciones"]}
				labels={["boveda","nombre", "apellido", "responsable", "fecha", "valor"]}
				pageRows={20} //Optional
				searchQuery={search} //Optional
				footerPages={5} //Optional
				onClienteUpdated={this.props.onClienteUpdated}
				onClienteDeleted={this.props.onClienteDeleted}
				server={this.props.server} />
			</div>
		);
	}
}
