const express = require('express');
const router = express.Router();
const rateLimit = require('express-rate-limit');
const mongoose = require('mongoose');

const Cliente = require('../models/clientes');

// Attempt to limit spam post requests for inserting data
const minutes = 5;
const postLimiter = rateLimit({
  windowMs: minutes * 60 * 1000, // milliseconds
  max: 100, // Limit each IP to 100 requests per windowMs 
  delayMs: 0, // Disable delaying - full speed until the max limit is reached 
  handler: (req, res) => {
    res.status(429).json({ success: false, msg: `You made too many requests. Please try again after ${minutes} minutes.` });
  }
});

// READ (ONE)
router.get('/:id', (req, res) => {
  Cliente.findById(req.params.id)
    .then((result) => {
      res.json(result);
    })
    .catch((err) => {
      res.status(404).json({ success: false, msg: `Cliente no encontrado` });
    });
});

// READ (ALL)
router.get('/', (req, res) => {
  Cliente.find({})
    .then((result) => {
      res.json(result);
    })
    .catch((err) => {
      res.status(500).json({ success: false, msg: `Algo salio mal. ${err}` });
    });
});


// CREATE
router.post('/', postLimiter, (req, res) => {

  let newCliente = new Cliente({
    boveda:         req.body.boveda,
    tipo:           req.body.tipo,
    forma:          req.body.forma,
    nombre:         req.body.nombre,
    apellido:       req.body.apellido,
    fecha:          req.body.fecha,
    cedula:         req.body.cedula,
    responsable:    req.body.responsable,
    direccion:      req.body.direccion,
    correo:         req.body.correo,
    telefono:       req.body.telefono,
    estado:         req.body.estado,
    valor:          req.body.valor,
    observacion:    req.body.observacion,
    certificado:    req.body.certificado,
    causamuerte:    req.body.causamuerte
  });

  newCliente.save()
    .then((result) => {
      res.json({
        success: true,
        msg: `Registro Agregado!`,
        result: {
          _id:          result._id,
          boveda:       result.boveda,
          tipo:         result.tipo,
          forma:        result.forma,
          nombre:       result.nombre,
          apellido:     result.apellido,
          fecha:        result.fecha,
          cedula:       result.cedula,
          responsable:  result.responsable,
          direccion:    result.direccion,     
          correo:       result.correo,     
          telefono:     result.telefono,     
          estado:       result.estado,
          valor:        result.valor,
          observacion:  result.observacion,
          certificado:  result.certificado,
          causamuerte:  result.causamuerte
        }
      });
    })
    .catch((err) => {
      console.log(err);
      if (err.errors) {
        if (err.errors.boveda) {
          res.status(400).json({ success: false, msg: err.errors.boveda.message });
          return;
        }
        if (err.errors.tipo) {
          res.status(400).json({ success: false, msg: err.errors.tipo.message });
          return;
        }
        if (err.errors.forma) {
          res.status(400).json({ success: false, msg: err.errors.forma.message });
          return;
        }
        if (err.errors.nombre) {
          res.status(400).json({ success: false, msg: err.errors.nombre.message });
          return;
        }
        if (err.errors.apellido) {
          res.status(400).json({ success: false, msg: err.errors.apellido.message });
          return;
        }
        if (err.errors.fecha) {
          res.status(400).json({ success: false, msg: err.errors.fecha.message });
          return;
        }
        if (err.errors.cedula) {
          res.status(400).json({ success: false, msg: err.errors.cedula.message });
          return;
        }
        if (err.errors.responsable) {
          res.status(400).json({ success: false, msg: err.errors.responsable.message });
          return;
        }
        if (err.errors.direccion) {
          res.status(400).json({ success: false, msg: err.errors.direccion.message });
          return;
        }
        if (err.errors.correo) {
          res.status(400).json({ success: false, msg: err.errors.correo.message });
          return;
        }
        if (err.errors.telefono) {
          res.status(400).json({ success: false, msg: err.errors.telefono.message });
          return;
        }
        if (err.errors.estado) {
          res.status(400).json({ success: false, msg: err.errors.estado.message });
          return;
        }
        if (err.errors.valor) {
          res.status(400).json({ success: false, msg: err.errors.valor.message });
          return;
        }
        if (err.errors.certificado) {
          res.status(400).json({ success: false, msg: err.errors.certificado.message });
          return;
        }
        if (err.errors.causamuerte) {
          res.status(400).json({ success: false, msg: err.errors.causamuerte.message });
          return;
        }
        // Show failed if all else fails for some reasons
        res.status(500).json({ success: false, msg: `Algo esta mal ${err}` });
      }
    });
});

// UPDATE
router.put('/:id', (req, res) => {


  let updatedCliente = {
    boveda:         req.body.boveda,
    tipo:           req.body.tipo,
    forma:          req.body.forma,
    nombre:         req.body.nombre,
    apellido:       req.body.apellido,
    fecha:          req.body.fecha,
    cedula:         req.body.cedula,
    responsable:    req.body.responsable,
    direccion:      req.body.direccion,
    correo:         req.body.correo,
    telefono:       req.body.telefono,
    estado:         req.body.estado,
    valor:          req.body.valor,
    observacion:    req.body.observacion,
    certificado:    req.body.certificado,
    causamuerte:    req.body.causamuerte
  };

  Cliente.findOneAndUpdate({ _id: req.params.id }, updatedCliente, { runValidators: true, context: 'query' })
    .then((oldResult) => {
      Cliente.findOne({ _id: req.params.id })
        .then((newResult) => {
          res.json({
            success: true,
            msg: `Registro Actualizado!`,
            result: 
            {
              _id: newResult._id,
              boveda:         newResult.boveda,
              tipo:           newResult.tipo,
              forma:          newResult.forma,
              nombre:         newResult.nombre,
              apellido:       newResult.apellido,
              fecha:          newResult.fecha,
              cedula:         newResult.cedula,
              responsable:    newResult.responsable,
              direccion:      newResult.direccion,        
              correo:         newResult.correo,        
              telefono:       newResult.telefono,        
              estado:         newResult.estado,
              valor:          newResult.valor,
              observacion:    newResult.observacion,
              certificado:    newResult.certificado,
              causamuerte:    newResult.causamuerte
            }
          });
        })
        .catch((err) => {
          res.status(500).json({ success: false, msg: `Algo saliooooo mal!. ${err}` });
          return;
        });
    })
    .catch((err) => {
      if (err.errors) {
        if (err.errors.boveda) {
          res.status(400).json({ success: false, msg: err.errors.boveda.message });
          return;
        }
        if (err.errors.tipo) {
          res.status(400).json({ success: false, msg: err.errors.tipo.message });
          return;
        }
        if (err.errors.forma) {
          res.status(400).json({ success: false, msg: err.errors.forma.message });
          return;
        }
        if (err.errors.nombre) {
          res.status(400).json({ success: false, msg: err.errors.nombre.message });
          return;
        }
        if (err.errors.apellido) {
          res.status(400).json({ success: false, msg: err.errors.apellido.message });
          return;
        }
        if (err.errors.fecha) {
          res.status(400).json({ success: false, msg: err.errors.fecha.message });
          return;
        }
        if (err.errors.cedula) {
          res.status(400).json({ success: false, msg: err.errors.cedula.message });
          return;
        }
        if (err.errors.responsable) {
          res.status(400).json({ success: false, msg: err.errors.edad.message });
          return;
        }
        if (err.errors.direccion) {
          res.status(400).json({ success: false, msg: err.errors.direccion.message });
          return;
        }
        if (err.errors.correo) {
          res.status(400).json({ success: false, msg: err.errors.correo.message });
          return;
        }
        if (err.errors.telefono) {
          res.status(400).json({ success: false, msg: err.errors.telefono.message });
          return;
        }
        if (err.errors.estado) {
          res.status(400).json({ success: false, msg: err.errors.estado.message });
          return;
        }
        if (err.errors.valor) {
          res.status(400).json({ success: false, msg: err.errors.valor.message });
          return;
        }
        if (err.errors.certificado) {
          res.status(400).json({ success: false, msg: err.errors.certificado.message });
          return;
        }
        if (err.errors.causamuerte) {
          res.status(400).json({ success: false, msg: err.errors.causamuerte.message });
          return;
        }


        // Show failed if all else fails for some reasons
        res.status(500).json({ success: false, msg: `Algo salios mal. ${err}` });
      }
    });
});

// DELETE
router.delete('/:id', (req, res) => {

  Cliente.findByIdAndRemove(req.params.id)
    .then((result) => {
      res.json({
        success: true,
        msg: `Registro eliminado.`,
        result: {
          _id:          result._id,
          boveda:       result.boveda,
          tipo:         result.tipo,
          forma:        result.forma,
          nombre:       result.nombre,
          apellido:     result.apellido,
          fecha:        result.fecha,
          cedula:       result.cedula,
          responsable:  result.responsable,
          direccion:    result.direccion,
          correo:       result.correo,
          telefono:     result.telefono,
          estado:       result.estado,
          valor:        result.valor,
          observacion:  result.observacion,
          certificado:  result.certificado,
          causamuerte:  result.causamuerte
        }
      });
    })
    .catch((err) => {
      res.status(404).json({ success: false, msg: 'Nada para eliminar.' });
    });
});

module.exports = router;