const express = require('express');
const router = express.Router();
const rateLimit = require('express-rate-limit');
const mongoose = require('mongoose');

const Usuario = require('../models/usuarios');

// Attempt to limit spam post requests for inserting data
const minutes = 5;
const postLimiter = rateLimit({
  windowMs: minutes * 60 * 1000, // milliseconds
  max: 100, // Limit each IP to 100 requests per windowMs 
  delayMs: 0, // Disable delaying - full speed until the max limit is reached 
  handler: (req, res) => {
    res.status(429).json({ success: false, msg: `You made too many requests. Please try again after ${minutes} minutes.` });
  }
});

// READ (ONE) - for login
router.get('/login', (req, res) => {
 // console.log(req.body.contrasena);
  const usuario = req.body.usuario;
  const contrasena = req.body.contrasena;

  if (!contrasena) {
    return res.status(400).json({ success: false, msg: 'Contraseña requerida' });
  }

  Usuario.findOne({ usuario: usuario, contrasena: contrasena })
    .then((result) => {
      if (!result) {
        return res.status(404).json({ success: false, msg: 'Credenciales incorrectas' });
      }
      res.json(result);
    })
    .catch((err) => {
      res.status(500).json({ success: false, msg: `Algo salio mal. ${err}` });
    });
});

// LOGIN (POST) - accept JSON body with usuario and contrasena
router.post('/login', postLimiter, (req, res) => {
  const usuario = req.body.usuario;
  const contrasena = req.body.contrasena;

  if (!contrasena) {
    return res.status(400).json({ success: false, msg: 'Contraseña requerida' });
  }

  Usuario.findOne({ usuario: usuario, contrasena: contrasena })
    .then((result) => {
      if (!result) {
        return res.status(404).json({ success: false, msg: 'Credenciales incorrectas' });
      }
      res.json(result);
    })
    .catch((err) => {
      res.status(500).json({ success: false, msg: `Algo salio mal. ${err}` });
    });
});

// READ (ALL)
router.get('/', (req, res) => {
  Usuario.find({})
    .then((result) => {
      res.json(result);
    })
    .catch((err) => {
      res.status(500).json({ success: false, msg: `Algo salio mal. ${err}` });
    });
});


// CREATE
router.post('/', postLimiter, (req, res) => {
console.log(req.body);
  let newUsuario = new Usuario({
    nombre:         req.body.nombre,
    apellido:       req.body.apellido,
    correo:         req.body.correo,
    usuario:        req.body.usuario,
    contrasena :    req.body.contrasena, 
    fecha:          req.body.fecha,
    estado:         req.body.estado
  });

  newUsuario.save()
    .then((result) => {
      res.json({
        success: true,
        msg: `Registro Agregado!`,
        result: {
          _id:          result._id,
          nombre:       result.nombre,
          apellido:     result.apellido,  
          correo:       result.correo,
          usuario:      result.usuario,
          contrasena:   result.contrasena,
          fecha:        result.fecha,
          estado:       result.estado
        }
      });
    })
    .catch((err) => {
  //    console.log(err);
      if (err.errors) {

        if (err.errors.nombre) {
          res.status(400).json({ success: false, msg: err.errors.nombre.message });
          return;
        }
        if (err.errors.apellido) {
          res.status(400).json({ success: false, msg: err.errors.apellido.message });
          return;
        }
        if (err.errors.correo) {
          res.status(400).json({ success: false, msg: err.errors.correo.message });
          return;
        }
        if (err.errors.usuario) {
          res.status(400).json({ success: false, msg: err.errors.usuario.message });
          return;
        }
        if (err.errors.contrasena) {
          res.status(400).json({ success: false, msg: err.errors.contrasena.message });
          return;
        }
        if (err.errors.fecha) {
          res.status(400).json({ success: false, msg: err.errors.fecha.message });
          return;
        }
        if (err.errors.estado) {
          res.status(400).json({ success: false, msg: err.errors.estado.message });
          return;
        }
        // Show failed if all else fails for some reasons
        res.status(500).json({ success: false, msg: `Algo esta mal ${err}` });
      }
    });
});

// UPDATE
router.put('/:id', (req, res) => {


  let updatedUsuario = {
    nombre:         req.body.nombre,
    apellido:       req.body.apellido,
    correo:         req.body.correo,
    usuario:        req.body.usuario,
    contrasena :    req.body.contrasena,
    fecha:          req.body.fecha,
    estado:         req.body.estado,
  };

  Usuario.findOneAndUpdate({ _id: req.params.id }, updatedUsuario, { runValidators: true, context: 'query' })
    .then((oldResult) => {
      Usuario.findOne({ _id: req.params.id })
        .then((newResult) => {
          res.json({
            success: true,
            msg: `Usuario Actualizado!`,
            result: 
            {
              _id: newResult._id,
              nombre:         newResult.nombre,
              apellido:       newResult.apellido,    
              correo:         newResult.correo,
              usuario:        newResult.usuario,
              contrasena:     newResult.contrasena, 
              fecha:          newResult.fecha,           
              estado:         newResult.estado,
            }
          });
        })
        .catch((err) => {
          res.status(500).json({ success: false, msg: `Algo saliooooo mal!. ${err}` });
          return;
        });
    })
    .catch((err) => {
      if (err.errors) {
        if (err.errors.nombre) {
          res.status(400).json({ success: false, msg: err.errors.nombre.message });
          return;
        }
        if (err.errors.apellido) {
          res.status(400).json({ success: false, msg: err.errors.apellido.message });
          return;
        }
        if (err.errors.correo) {
          res.status(400).json({ success: false, msg: err.errors.correo.message });
          return;
        }
        if (err.errors.usuario) {
          res.status(400).json({ success: false, msg: err.errors.usuario.message });
          return;
        }
        if (err.errors.contrasena) {
          res.status(400).json({ success: false, msg: err.errors.contrasena.message });
          return;
        }
        if (err.errors.fecha) {
          res.status(400).json({ success: false, msg: err.errors.fecha.message });
          return;
        }
        if (err.errors.estado) {
          res.status(400).json({ success: false, msg: err.errors.estado.message });
          return;
        }
        // Show failed if all else fails for some reasons
        res.status(500).json({ success: false, msg: `Algo salios mal. ${err}` });
      }
    });
});

// DELETE
router.delete('/:id', (req, res) => {
console.log(req.params.id);
  Usuario.findByIdAndRemove(req.params.id)
    .then((result) => {
      res.json({
        success: true,
        msg: `Usuario eliminado.`,
        result: {
          _id:          result._id,
          nombre:       result.nombre,
          apellido:     result.apellido,
          correo:       result.correo,
          usuario:      result.usuario,
          contrasena:   result.contrasena,
          fecha:        result.fecha,
          estado:       result.estado,
        }
      });
    })
    .catch((err) => {
      res.status(404).json({ success: false, msg: 'Nada para eliminar.' });
    });
});

module.exports = router;
